﻿using GTSPL_SDK;
using System;
using System.Collections.Generic;
using System.Diagnostics;
//using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Timers;
using Timer = System.Timers.Timer;
using System.Drawing;
using System.Drawing.Imaging;

namespace DotNet_SampleCode
{
    /// <summary>
    /// MainWindow.xaml 的互動邏輯
    /// </summary>
    public partial class MainWindow : Window
    {
        Driver driver = new Driver();
        USB usb = new USB();
        SocketConnect socketconnect = new SocketConnect();
        //定時發送命另計時器
        Timer sendCmdTimer;
        static bool IsRealStatus = false;
        static bool IsSocketconnectRealStatus = false;

        public MainWindow()
        {
            InitializeComponent();

            /* 偵測印表機裝置 */
            string[] PrinterName = usb.detectUSB_USB();
            //          string[] PrinterName= usb.detectUSBStr_USB() == null ? null : usb.detectUSBStr_USB().Split('\n'); 
            if (PrinterName != null)
            {
                for (int PrinterIndex = 0; PrinterIndex < PrinterName.Length; PrinterIndex++)
                {
                    if (PrinterName[PrinterIndex] != null)
                        PrinterNameCom.Items.Insert(PrinterIndex, PrinterName[PrinterIndex]);
                }
            }
            PrinterNameCom.SelectedIndex = PrinterNameCom.Items.Count - 1;
        }

        public int OpenPort()
        {
            string pName = PrinterNameTxt.Text;

            if (pName != "")
            {
                int result = driver.openport(pName);
                //int result = driver.openport(@"\\192.168.1.104\Printer Model");
                return result;
            }
            else
            {

                MessageBox.Show("Please enter the printer first!");
                return 0;
            }
        }

        public int OpenPortUSB()
        {
            int result = usb.openport_USB();
            return result;

        }

        public int OpenPortsUSB(string Printer)
        {
            if (Printer != "")
            {
                int result = usb.openports_USB(Printer);
                return result;
            }
            else
            {
                return 0;
            }

        }
        public int OpenPortEthernet()
        {
            string IP = IPTxt.Text;
            int Port = 0;
            try
            {
                Port = Int32.Parse(portTxt.Text);

            }
            catch (Exception)
            {
                if (RealTimeStatusEthernet.Content.ToString() == "Close Real Time Status")
                {
                    RealTimeStatusEthernet.Content = "Open Real Time Status";
                    IsRealStatus = false;
                    stopSendCmdTimer();
                }
                MessageBox.Show("Port 格式錯誤或未填寫");
                return 0;
            }

            if (IP == "" || IP == null)
            {
                if (RealTimeStatusEthernet.Content.ToString() == "Close Real Time Status")
                {
                    RealTimeStatusEthernet.Content = "Open Real Time Status";
                    IsRealStatus = false;
                    stopSendCmdTimer();
                }
                MessageBox.Show("未填寫ip");
                return 0;
            }

            /*防止實時狀態*/
            if (SocketConnect.connectCode == 1)
            {
                IsSocketconnectRealStatus = false;
                socketconnect.closeport_Ethernet();
            }

            if (SocketConnect.connectCode != 1) //未連線
            {
                socketconnect.openport_Ethernet(IP, Port);
                Console.WriteLine(SocketConnect.connectCode);
                return SocketConnect.connectCode;
            }
            else
            {
                return 0;
            }

        }

        string StatusNumToString(string statusNum)
        {
            string statusString = "";
            switch (statusNum)
            {
                case "00":
                    statusString = "Normal";
                    break;
                case "01":
                    statusString = "Head opened";
                    break;
                case "02":
                    statusString = "Paper Jam";
                    break;
                case "03":
                    statusString = "Paper Jam and head opened";
                    break;
                case "04":
                    statusString = "Out of paper";
                    break;
                case "05":
                    statusString = "Out of paper and head opened";
                    break;
                case "08":
                    statusString = "Out of ribbon";
                    break;
                case "09":
                    statusString = "Out of ribbon and head opened";
                    break;
                case "0A":
                    statusString = "Out of ribbon and paper jam";
                    break;
                case "0B":
                    statusString = "Out of ribbon, paper jam and head opened";
                    break;
                case "0C":
                    statusString = "Out of ribbon and out of paper";
                    break;
                case "0D":
                    statusString = "Out of ribbon, out of paper and head opened";
                    break;
                case "10":
                    statusString = "Pause";
                    break;
                case "20":
                    statusString = "Printing";
                    break;
                case "80":
                    statusString = "Other error";
                    break;
            }
            return statusString;
        }

        //啟動定時發送命令
        private void startSendCmdTimer()
        {
            sendCmdTimer = new Timer();
            sendCmdTimer.Interval = 1000;
            sendCmdTimer.Elapsed += timer_Send;
            sendCmdTimer.Start();
        }

        private void timer_Send(object sender, ElapsedEventArgs e)
        {
            Dispatcher.BeginInvoke(new Action(() =>
            {
                int result = 0;
                if (PortTab.SelectedIndex == 1)
                {
                    if (PrinterNameCom.SelectedItem != null)
                        result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());

                    if (result != 0)
                    {
                        var status = "";
                        status = usb.printerstatus_USB();
                        RealTimeStatusUSBTxt.Text = StatusNumToString(status);
                        usb.closeport_USB();
                    }
                    else
                    {
                        RealTimeStatusUSBTxt.Text = "Fail to open port!";
                        RealTimeStatusUSB.Content = "Open Real Time Status";
                        IsRealStatus = false;
                        stopSendCmdTimer();
                    }
                }
                else
                {
                    if (IsSocketconnectRealStatus == false)
                    {
                        result = OpenPortEthernet();

                        if (result != 0)
                        {
                            IsSocketconnectRealStatus = true;
                        }
                        else
                        {
                            RealTimeStatusEthernetTxt.Text = "Fail to open port!";
                            RealTimeStatusEthernet.Content = "Open Real Time Status";
                            IsRealStatus = false;
                            stopSendCmdTimer();
                        }
                    }
                    var status = "";
                    status = socketconnect.printerstatus_Ethernet();
                    RealTimeStatusEthernetTxt.Text = StatusNumToString(status);
                }


                /*      if (result != 0)
                      {

                          if (PortTab.SelectedIndex == 1)
                          {

                                  var status = "";
                                  status = usb.printerstatus_USB();
                                  RealTimeStatusUSBTxt.Text = StatusNumToString(status);


                          }
                          else
                          {
                              var status = "";
                              status = socketconnect.printerstatus_Ethernet();
                              RealTimeStatusEthernetTxt.Text = StatusNumToString(status);
                          }


                          if (PortTab.SelectedIndex == 1)
                              usb.closeport_USB();
                          else
                              socketconnect.closeport_Ethernet();
                      }
                      else
                      {
                          if (PortTab.SelectedIndex == 1)
                          {
                              RealTimeStatusUSBTxt.Text = "Fail to open port!";
                              RealTimeStatusUSB.Content = "Open Real Time Status";
                          }
                          else
                          {
                              RealTimeStatusEthernetTxt.Text = "Fail to open port!";
                              RealTimeStatusEthernet.Content = "Open Real Time Status";
                          }
                          IsRealStatus = false;
                          stopSendCmdTimer();
                      }*/
            }));
        }

        //關閉定時發送命令
        private void stopSendCmdTimer()
        {
            if (sendCmdTimer != null)
            {
                sendCmdTimer.Stop();
                sendCmdTimer.Dispose();
                sendCmdTimer.Enabled = false;
                if (PortTab.SelectedIndex == 2)
                {
                    IsSocketconnectRealStatus = false;
                    socketconnect.closeport_Ethernet();
                }
            }
        }

        private void TabControl_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            TabControl tabControl = sender as TabControl;
            TabItem selectedTab = tabControl.SelectedItem as TabItem;

            if (PortTab.SelectedIndex == 1)
            {
                if (RealTimeStatusEthernet.Content.ToString() == "Close Real Time Status")
                {
                    RealTimeStatusEthernet.Content = "Open Real Time Status";
                    IsRealStatus = false;
                    stopSendCmdTimer();
                }
            }
            else if (PortTab.SelectedIndex == 2)
            {
                if (RealTimeStatusUSB.Content.ToString() == "Close Real Time Status")
                {
                    RealTimeStatusUSB.Content = "Open Real Time Status";
                    IsRealStatus = false;
                    stopSendCmdTimer();
                }
            }
            else
            {
                if (RealTimeStatusEthernet.Content.ToString() == "Close Real Time Status")
                {
                    RealTimeStatusEthernet.Content = "Open Real Time Status";
                    IsRealStatus = false;
                    stopSendCmdTimer();
                }

                if (RealTimeStatusUSB.Content.ToString() == "Close Real Time Status")
                {
                    RealTimeStatusUSB.Content = "Open Real Time Status";
                    IsRealStatus = false;
                    stopSendCmdTimer();
                }
            }
        }

        private void SetPrinterBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.setup("104", "76", "2", "3", "0", "3", "0");
                driver.sendcommand("DIRECTION 1");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintBarBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.clearbuffer();
                driver.barcode("30", "30", "128", "100", "1", "0", "2", "2", "barcode1234567");
                driver.printlabel("1", "1");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintFontBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.clearbuffer();
                //driver.printerfont("50", "10", "TSS16.BF2", "0", "1", "1", "默认简体中文测试：海天米醋白米醋1瓶450ml");
                driver.printerfont("50", "10", "3", "0", "1", "1", "Print Font 123456");
                driver.printlabel("1", "1");
                driver.closeport();
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintBlockBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.clearbuffer();
                driver.printerfontblock("35", "15", "790", "90", "0", "0", "8", "8", "0", "1", "We stand behind our products with one of the most comprehensive support programs in the Auto-ID industry.");
                driver.printlabel("1", "1");
                driver.closeport();
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintDownloadPcxBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            string file = Environment.CurrentDirectory;
            if (result != 0)
            {
                driver.clearbuffer();
                driver.downloadpcx(file + "\\UL.PCX", "UL.PCX");
                driver.sendcommand("PUTPCX 50,10,\"UL.PCX\"");
                driver.printlabel("1", "1");
                driver.closeport();
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintDownloadBmpBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            string file = Environment.CurrentDirectory;
            if (result != 0)
            {
                driver.clearbuffer();
                driver.downloadbmp(file + "\\CIRCLE.BMP", "CIRCLE.BMP");
                driver.sendcommand("PUTBMP 150,30,\"CIRCLE.BMP\"");
                driver.printlabel("1", "1");
                driver.closeport();
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintWinFontBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            string file = Environment.CurrentDirectory;
            if (result != 0)
            {
                driver.clearbuffer();
            //    driver.downloadbmp(file + "\\impact.ttf", "impact.ttf");
                driver.windowsfont(100, 20, 48, 0, 0, 0, "impact", "C# Driver test");
                driver.printlabel("1", "1");
                driver.closeport();

            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }

        }

        private void GetDllVerBtn_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("Dll Version:" + driver.getDLLVersion(1));
        }

        //單獨寫入資料
        private void WriteEPCBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.writeUHF("H", 2, 12, "E", "414142424343444445454646");
                driver.printlabel("1", "1");
                driver.closeport();
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        //寫入資料 => 寫入access pwd => 上鎖access pwd => 上鎖
        private void Write_Lock_Btn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.writeUHF("H", 2, 12, "E", "414142424343444445454646");
                driver.AccessPWD_Action("S", "87654321");
                driver.printlabel("1", "1");
                driver.closeport();
                Thread.Sleep(1000);
                result = OpenPort();
                if (result != 0)
                {
                    driver.AccessPWD_Action("L", "87654321");
                    driver.EPCPWD_Action("L", "87654321");
                    driver.printlabel("1", "1");
                    driver.closeport();
                }
                else
                {
                    MessageBox.Show("Fail to open port!");
                }
            }


            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        //寫入EPC資料+變更寫入密碼
        private void WEPCChangeWPwdBtn_Click(object sender, RoutedEventArgs e)
        {
            GJBFunctionInfomationLab.Content = "Write EPC data :\nHex format, block no.=1, write 12 bytes, EPC Bank,\nEPC data=414142424343444445454646,Write PWD=12345678\n" +
                                       "Changing write PWD :\nNew PWD = 87654321, Write PWD=12345678";
            int result = OpenPort();
            if (result != 0)
            {
                driver.writeGJB_UHF("H", 1, 12, "E", "414142424343444445454646", "12345678");
                driver.setPWD_Action("W", "S", "87654321", "12345678");
                driver.printlabel("1", "1");
                driver.closeport();
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        //寫入EPC/USER資料+變更寫入密碼
        private void WEPCUSERChangeWPwdBtn_Click(object sender, RoutedEventArgs e)
        {
            GJBFunctionInfomationLab.Content = "Write EPC/USER data :\nHex format, block no.=1, write EPC/USER:12/10 bytes,EPC/USER Bank,\nEPC data=414142424343444445454646,\nUSER Data=30313233343536373839, Write PWD =12345678\n" +
                                       "Changing write PWD :\nNew PWD = 87654321, Write PWD=12345678";
            int result = OpenPort();
            if (result != 0)
            {
                driver.writeGJB_UHF("H", 1, 12, "E", "414142424343444445454646", "12345678");
                driver.writeGJB_UHF("H", 1, 10, "U", "30313233343536373839", "12345678");
                driver.setPWD_Action("W", "S", "87654321", "12345678");
                driver.printlabel("1", "1");
                driver.closeport();
            }

            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        //寫入+設定EPC/USER資料及狀態+變更寫入/狀態密碼
        private void WSetStatEUChangeWSPwdBtn_Click(object sender, RoutedEventArgs e)
        {
            GJBFunctionInfomationLab.Content = "Write EPC/USER data :\nHex format, block no.=1, write EPC/USER:12/10 bytes,EPC/USER Bank,\nEPC data=414142424343444445454646,\nUSER Data=30313233343536373839, Write PWD =12345678\n" +
               "Set EPC/USER status :\nEPC/USER Bank: read/not write, Status PWD=00000000\n" +
               "Changing write/status PWD :\nNew write PWD = 87654321, New status PWD = 11112222,\nWrite PWD=12345678";
            int result = OpenPort();
            if (result != 0)
            {
                driver.writeGJB_UHF("H", 1, 12, "E", "414142424343444445454646", "12345678");
                driver.writeGJB_UHF("H", 1, 10, "U", "30313233343536373839", "12345678");
                driver.statusGJB_UHF("E", "B", "00000000");
                driver.statusGJB_UHF("U", "B", "00000000");
                driver.setPWD_Action("S", "S", "11112222", "12345678");
                driver.setPWD_Action("W", "S", "87654321", "12345678");
                driver.printlabel("1", "1");
                driver.closeport();
            }

            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        //寫入+設定EPC/USER/TID/SAFE資料及狀態+變更寫入/讀取/狀態/刪除密碼
        private void WSetStatEUTSChangeWRSKPwdBtn_Click(object sender, RoutedEventArgs e)
        {
            GJBFunctionInfomationLab.Content = "Write EPC/USER data :\nHex format, block no.=1, write EPC/USER:12/10 bytes,EPC/USER Bank,\nEPC data=414142424343444445454646,\nUSER Data=30313233343536373839, Write PWD =12345678\n" +
               "Set EPC/USER/TID/SAFE status :\nEPC/USER/TID Bank: read/not write, SAFE Bank: not read/not write,\nStatus PWD=00000000\n" +
               "Changing write/read/status/kill PWD :\nNew write PWD = 87654321, New read PWD = 33334444,\nNew status PWD = 11112222, New kill PWD = 55556666,\nWrite PWD=12345678";
            int result = OpenPort();
            if (result != 0)
            {
                driver.writeGJB_UHF("H", 1, 12, "E", "414142424343444445454646", "12345678");
                driver.writeGJB_UHF("H", 1, 10, "U", "30313233343536373839", "12345678");
                driver.statusGJB_UHF("E", "B", "00000000");
                driver.statusGJB_UHF("U", "B", "00000000");
                driver.statusGJB_UHF("T", "B", "00000000");
                driver.statusGJB_UHF("F", "D", "00000000");
                driver.setPWD_Action("S", "S", "11112222", "12345678");
                driver.setPWD_Action("R", "S", "33334444", "12345678");
                driver.setPWD_Action("K", "S", "55556666", "12345678");
                driver.setPWD_Action("W", "S", "87654321", "12345678");
                driver.printlabel("1", "1");
                driver.closeport();
            }

            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        //USB
        private void GetPrinterStatus_Click(object sender, RoutedEventArgs e)
        {
            if (IsRealStatus == true)
                stopSendCmdTimer();

            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();

            if (result != 0)
            {
                var status = "";
                if (PortTab.SelectedIndex == 1)
                    status = usb.printerstatus_USB();
                else
                    status = socketconnect.printerstatus_Ethernet();

                MessageBox.Show(StatusNumToString(status));
                if (PortTab.SelectedIndex == 1)
                    usb.closeport_USB();
                else
                    socketconnect.closeport_Ethernet();

            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }

            if (IsRealStatus == true)
            {
                startSendCmdTimer();
            }
        }

        private void SetPrinterUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.setup_USB("104", "76", "2", "3", "0", "3", "0");
                    usb.sendcommand_USB("DIRECTION 1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.setup_Ethernet("104", "76", "2", "3", "0", "3", "0");
                    socketconnect.sendcommand_Ethernet("DIRECTION 1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintBarUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    //usb.sendcommand_USB("QRCODE 220, 260, M, 6, A, 0, M2, S7, \"AABCB03abcN123\"");
                    //     usb.sendcommand_USB("QRCODE 220,260,M,3,A,0,M2,S7,\"AABCB03abcN123\"");
                    usb.barcode_USB("30", "30", "128", "100", "1", "0", "2", "2", "barcode1234567");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    if (SocketConnect.connectCode == 2)
                    {
                        MessageBox.Show("WAIT_TIMEOUT");
                        return;
                    }
                    socketconnect.barcode_Ethernet("30", "30", "128", "100", "1", "0", "2", "2", "barcode1234567");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintFontUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    usb.printerfont_USB("50", "10", "TSS24.BF2", "0", "1", "1", "默认简体中文测试：海天米醋白米醋1瓶450ml");
                    //usb.printerfont_USB("50", "10", "impact.ttf", "0", "12", "12", "abcdefghijklmn");
                    //usb.printerfont_USB("50", "10", "TSS16.BF2:", "0", "1", "1", "Print Font 123456");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.printerfont_Ethernet("50", "10", "TSS24.BF2", "0", "1", "1", "默认简体中文测试：海天米醋白米醋1瓶450ml");
                    //usb.printerfont_USB("50", "10", "impact.ttf", "0", "12", "12", "abcdefghijklmn");
                    //usb.printerfont_USB("50", "10", "TSS16.BF2:", "0", "1", "1", "Print Font 123456");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }

            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintBlockUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    usb.printerfontblock_USB("35", "15", "790", "90", "TSS24.BF2", "0", "1", "1", "0", "1", "默认简体中文测试：海天米醋白米醋1瓶450ml");
                    //usb.printerfont_USB("50", "10", "impact.ttf", "0", "12", "12", "abcdefghijklmn");
                    //usb.printerfont_USB("50", "10", "TSS16.BF2:", "0", "1", "1", "Print Font 123456");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.printerfontblock_Ethernet("35", "15", "790", "90", "TSS24.BF2", "0", "1", "1", "0", "1", "默认简体中文测试：海天米醋白米醋1瓶450ml");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }

            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintDownloadPcxUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            string file = Environment.CurrentDirectory;
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    usb.downloadpcx_USB(file + "\\UL.PCX", "UL.PCX");
                    //usb.downloadpcx_USB(file + "\\BITMAP.PCX", "BITMAP.PCX");
                    usb.sendcommand_USB("PUTPCX 50,10,\"UL.PCX\"");
                    //usb.sendcommand_USB("PUTPCX 50,10,\"BITMAP.PCX\"");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.downloadpcx_Ethernet(file + "\\UL.PCX", "UL.PCX");
                    //usb.downloadpcx_USB(file + "\\BITMAP.PCX", "BITMAP.PCX");
                    socketconnect.sendcommand_Ethernet("PUTPCX 50,10,\"UL.PCX\"");
                    //usb.sendcommand_USB("PUTPCX 50,10,\"BITMAP.PCX\"");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintDownloadBmpUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            /*    string fontName = "微软雅黑";
                float fontemsize = 16;
                string Content = "固定资产";
                int fontHeight = 20;
                Bitmap fontImage = CreateImageByte(Content, fontName, fontemsize, fontHeight);
                Bitmap fontImage1 = ConvertTo1Bpp(fontImage);
                Bitmap newbitmap = fontImage1.Clone(new System.Drawing.Rectangle(0, 0, fontImage1.Width, fontImage1.Height), System.Drawing.Imaging.PixelFormat.Format1bppIndexed);

                byte[] SendBmpData;
                uint sendWidth = 0;     //实际发送的宽
                uint sendHeight = 0;    //实际发送的高
                sendHeight = (uint)newbitmap.Height;
                sendWidth = (uint)newbitmap.Width;
                byte[] setHBit = { 0x80, 0x40, 0x30, 0x10, 0x08, 0x04, 0x02, 0x01 };    //算法辅助 置1
                byte[] clsLBit = { 0x7F, 0xBF, 0xDF, 0xEF, 0xF7, 0xFB, 0xFD, 0xFE };    //算法辅助 置0

                if (newbitmap.Height % 8 != 0)
                    sendHeight = sendHeight + 8 - sendHeight % 8;
                if (newbitmap.Width % 8 != 0)
                    sendWidth = sendWidth + 8 - sendWidth % 8;


                SendBmpData = new byte[sendWidth * sendHeight / 8];
                memset(SendBmpData, 0xff, (int)(sendWidth * sendHeight / 8));//0XFF为全白

                #region 求灰度平均值
                Double redSum = 0, geedSum = 0, blueSum = 0;
                Double total = sendWidth * sendHeight;
                byte[] huiduData = new byte[sendWidth * sendHeight / 8];
                for (int i = 0; i < newbitmap.Width; i++)
                {
                    int ta = 0, tr = 0, tg = 0, tb = 0;
                    for (int j = 0; j < newbitmap.Height; j++)
                    {
                        System.Drawing.Color getcolor = newbitmap.GetPixel(i, j);//取每个点颜色
                        ta = getcolor.A;
                        tr = getcolor.R;
                        tg = getcolor.G;
                        tb = getcolor.B;
                        redSum += ta;
                        geedSum += tg;
                        blueSum += tb;
                    }
                }
                int meanr = (int)(redSum / total);
                int meang = (int)(geedSum / total);
                int meanb = (int)(blueSum / total);
                #endregion 求灰度平均值

                for (int j = 0; j < newbitmap.Height; j++)
                {
                    for (int i = 0; i < newbitmap.Width; i++)
                    {
                        System.Drawing.Color getcolor = newbitmap.GetPixel(i, j);//取每个点颜色
                        if ((getcolor.R * 0.299) + (getcolor.G * 0.587) + (getcolor.B * 0.114) < ((meanr * 0.299) + (meang * 0.587) + (meanb * 0.114)))//颜色转灰度(可调 0-255)
                            SendBmpData[j * sendWidth / 8 + i / 8] &= clsLBit[i % 8];
                    }
                }*/

            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            string file = Environment.CurrentDirectory;
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    usb.downloadbmp_USB(file + "\\CIRCLE.bmp", "CIRCLE.bmp");
                    usb.sendcommand_USB("PUTBMP 10,10,\"CIRCLE.bmp\"");
                    //usb.downloadbmp_USB(file + "\\web.bmp", "web.bmp");
                    //usb.sendcommand_USB("PUTBMP 10,10,\"web.bmp\"");

                    /*              usb.sendcommand_USB("SIZE " + (sendWidth / 8  + 4).ToString() + " mm," + (sendHeight / 8 + 3).ToString() + " mm");
                                    usb.sendcommand_noClRf_USB("BITMAP 24,20," + (sendWidth / 8).ToString() + "," + sendHeight.ToString() + ",0,");
                                    usb.sendcommand_USB(SendBmpData);*/
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.downloadbmp_Ethernet(file + "\\CIRCLE.BMP", "CIRCLE.BMP");
                    socketconnect.sendcommand_Ethernet("PUTBMP 10,10,\"CIRCLE.BMP\"");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        /*        public void memset(byte[] buf, byte val, int size)
                {
                    int i;
                    for (i = 0; i < size; i++)
                        buf[i] = val;
                }

                // 文字(支持漢字)建立圖片
                public static Bitmap CreateImageByte(string content, string fontfamily, float fontSize, int height)
                {
                    int AiiscCount = 0;
                    int NotAiiscCount = 0;
                    foreach (char ch in content)
                    {
                        //篩選漢字與正常的Aiisc值用於計算寬度
                        if (ch >= 255)
                        {
                            NotAiiscCount++;
                        }
                        else
                        {
                            AiiscCount++;
                        }
                    }
                    //設置寬
                    int width = (int)(NotAiiscCount * fontSize * 1.4) + (int)(AiiscCount * fontSize * 0.8) + 8;
                    //文字相對X軸坐標(参考數學數軸)
                    float X = 0;
                    //文字相對Y軸坐標(参考數學數軸)
                    float Y = 0;
                    //建立圖片
                    Bitmap bitmap = new Bitmap(width, height + 8, System.Drawing.Imaging.PixelFormat.Format32bppRgb);
                    //設置字體
                    Font font = new Font(fontfamily, fontSize, System.Drawing.FontStyle.Regular);
                    RectangleF rect = new System.Drawing.Rectangle(0, 0, width, height + 8);
                    StringFormat format = new StringFormat(StringFormatFlags.NoClip);
                    Graphics g = Graphics.FromImage(bitmap);
                    //使用ClearType字體功能
                    g.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAlias;
                    g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
                    g.FillRectangle(new SolidBrush(System.Drawing.Color.White), rect);
                    g.DrawString(content, font, System.Drawing.Brushes.Black, rect, format);
                    g.Dispose();
                    return bitmap;
                }

                public static Bitmap ConvertTo1Bpp(Bitmap bt)
                {
                    System.Drawing.Color p1;
                    Bitmap bt1 = bt.Clone() as Bitmap;
                    for (int x1 = 0; x1 < bt.Width; x1++)
                    {
                        for (int x2 = 0; x2 < bt.Height; x2++)
                        {
                            p1 = bt.GetPixel(x1, x2);
                            int temp = (p1.R + p1.B + p1.G) / 3;
                            bt1.SetPixel(x1, x2, System.Drawing.Color.FromArgb(temp, temp, temp));
                        }
                    }

                    System.Drawing.Color p2;
                    for (int x1 = 0; x1 < bt1.Width; x1++)
                    {
                        for (int x2 = 0; x2 < bt1.Height; x2++)
                        {
                            p2 = bt1.GetPixel(x1, x2);
                            if (p2.G > 150)
                            {
                                bt1.SetPixel(x1, x2, System.Drawing.Color.FromArgb(255, 255, 255));
                            }
                            else
                            {
                                bt1.SetPixel(x1, x2, System.Drawing.Color.FromArgb(0, 0, 0));
                            }
                        }
                    }

                    return bt1;
                }*/

        private void PrintWinFontUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            string file = Environment.CurrentDirectory;
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                 //   usb.downloadbmp_USB(file + "\\impact.ttf", "impact.ttf");
                    usb.windowsfont_USB(10, 100, 48, 0, 0, 0, "impact", "C# WIN TEST");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.downloadbmp_Ethernet(file + "\\impact.ttf", "impact.ttf");
                    socketconnect.windowsfont_Ethernet(10, 100, 48, 0, 0, 0, "impact", "C# WIN TEST");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void GetDllVerUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("Dll Version:" + usb.getDLLVersion_USB(1));
        }

        //單獨寫入資料
        private void WriteEPC_USBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.writeUHF_USB("H", 2, 12, "E", "414142424343444445454646");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.writeUHF_Ethernet("H", 2, 12, "E", "414142424343444445454646");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }


        //寫入資料 => 寫入access pwd => 上鎖access pwd => 上鎖
        private void Write_Lock_USBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    usb.writeUHF_USB("H", 2, 12, "E", "414142424343444445454646");
                    usb.writeUHF_USB("H", 2, 4, "R", "12345678");
                    //usb.AccessPWD_Action_USB("S", "12345678");
                    //Thread.Sleep(1000);
                    usb.AccessPWD_Action_USB("L", "12345678");
                    usb.EPCPWD_Action_USB("L", "12345678");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.writeUHF_Ethernet("H", 2, 12, "E", "414142424343444445454646");
                    socketconnect.AccessPWD_Action_Ethernet("S", "12345678");
                    Thread.Sleep(1000);
                    socketconnect.AccessPWD_Action_Ethernet("L", "12345678");
                    socketconnect.EPCPWD_Action_Ethernet("L", "12345678");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        //讀取資料
        private void ReadEPC_USBBtn_Click(object sender, RoutedEventArgs e)
        {
            if (IsRealStatus == true)
                stopSendCmdTimer();
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    string data = usb.readUHF_USB("H", 2, 12, "E");
                    switch (data)
                    {
                        case "640000000000000000000000":
                            MessageBox.Show("Other errors");
                            break;
                        case "650000000000000000000000":
                            MessageBox.Show("More than memory space");
                            break;
                        case "660000000000000000000000":
                            MessageBox.Show("The memory is locked");
                            break;
                        case "670000000000000000000000":
                            MessageBox.Show("Insufficient reading power");
                            break;
                        case "680000000000000000000000":
                            MessageBox.Show("Unspecified error");
                            break;
                        case "690000000000000000000000":
                            MessageBox.Show("CRC error");
                            break;
                        case "6A0000000000000000000000":
                            MessageBox.Show("If an error occurs during writing, how many words have been written in the reply.");
                            break;
                        case "6B0000000000000000000000":
                            MessageBox.Show("If the Tag tag responds incorrectly during writing, the error code plus the number of words written.");
                            break;
                        case "6C0000000000000000000000":
                            MessageBox.Show("No tags");
                            break;
                        case "6D0000000000000000000000":
                            MessageBox.Show("Command format error");
                            break;
                        case "6E0000000000000000000000":
                            MessageBox.Show("Failed to set power strength");
                            break;
                        case "6F0000000000000000000000":
                            MessageBox.Show("Failed to set regulations");
                            break;
                        default:
                            MessageBox.Show(data);
                            break;
                    }
                    usb.closeport_USB();
                }
                else
                {
                    string data = socketconnect.readUHF_Ethernet("H", 2, 12, "E");
                    switch (data)
                    {
                        case "640000000000000000000000":
                            MessageBox.Show("Other errors");
                            break;
                        case "650000000000000000000000":
                            MessageBox.Show("More than memory space");
                            break;
                        case "660000000000000000000000":
                            MessageBox.Show("The memory is locked");
                            break;
                        case "670000000000000000000000":
                            MessageBox.Show("Insufficient reading power");
                            break;
                        case "680000000000000000000000":
                            MessageBox.Show("Unspecified error");
                            break;
                        case "690000000000000000000000":
                            MessageBox.Show("CRC error");
                            break;
                        case "6A0000000000000000000000":
                            MessageBox.Show("If an error occurs during writing, how many words have been written in the reply.");
                            break;
                        case "6B0000000000000000000000":
                            MessageBox.Show("If the Tag tag responds incorrectly during writing, the error code plus the number of words written.");
                            break;
                        case "6C0000000000000000000000":
                            MessageBox.Show("No tags");
                            break;
                        case "6D0000000000000000000000":
                            MessageBox.Show("Command format error");
                            break;
                        case "6E0000000000000000000000":
                            MessageBox.Show("Failed to set power strength");
                            break;
                        case "6F0000000000000000000000":
                            MessageBox.Show("Failed to set regulations");
                            break;
                        default:
                            MessageBox.Show(data);
                            break;
                    }
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
            if (IsRealStatus == true)
                startSendCmdTimer();
        }

        private void Read_QueryEPC_USBBtn_Click(object sender, RoutedEventArgs e)
        {
            if (IsRealStatus == true)
                stopSendCmdTimer();
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    string data = usb.query_UHF_USB("H", 0, 0);
                    data = data.Replace("\r\n", "");
               //     switch (data)
                    {
                        //case "640000000000000000000000":
                        //    MessageBox.Show("Other errors");
                        //    break;
                        //case "650000000000000000000000":
                        //    MessageBox.Show("More than memory space");
                        //    break;
                        //case "660000000000000000000000":
                        //    MessageBox.Show("The memory is locked");
                        //    break;
                        //case "670000000000000000000000":
                        //    MessageBox.Show("Insufficient reading power");
                        //    break;
                        //case "680000000000000000000000":
                        //    MessageBox.Show("Unspecified error");
                        //    break;
                        //case "690000000000000000000000":
                        //    MessageBox.Show("CRC error");
                        //    break;
                        //case "6A0000000000000000000000":
                        //    MessageBox.Show("If an error occurs during writing, how many words have been written in the reply.");
                        //    break;
                        //case "6B0000000000000000000000":
                        //    MessageBox.Show("If the Tag tag responds incorrectly during writing, the error code plus the number of words written.");
                        //    break;
                        //case "6C0000000000000000000000":
                        //    MessageBox.Show("No tags");
                        //    break;
                        //case "6D0000000000000000000000":
                        //    MessageBox.Show("Command format error");
                        //    break;
                        //case "6E0000000000000000000000":
                        //    MessageBox.Show("Failed to set power strength");
                        //    break;
                        //case "6F0000000000000000000000":
                        //    MessageBox.Show("Failed to set regulations");
                        //    break;
                        //default:
                            MessageBox.Show(data);
                        //    break;
                    }
                    usb.closeport_USB();
                }
                else
                {
                    string data = socketconnect.query_UHF_Ethernet("H", 0, 0);
                    data = data.Replace("\r\n", "");
                    switch (data)
                    {
                        case "640000000000000000000000":
                            MessageBox.Show("Other errors");
                            break;
                        case "650000000000000000000000":
                            MessageBox.Show("More than memory space");
                            break;
                        case "660000000000000000000000":
                            MessageBox.Show("The memory is locked");
                            break;
                        case "670000000000000000000000":
                            MessageBox.Show("Insufficient reading power");
                            break;
                        case "680000000000000000000000":
                            MessageBox.Show("Unspecified error");
                            break;
                        case "690000000000000000000000":
                            MessageBox.Show("CRC error");
                            break;
                        case "6A0000000000000000000000":
                            MessageBox.Show("If an error occurs during writing, how many words have been written in the reply.");
                            break;
                        case "6B0000000000000000000000":
                            MessageBox.Show("If the Tag tag responds incorrectly during writing, the error code plus the number of words written.");
                            break;
                        case "6C0000000000000000000000":
                            MessageBox.Show("No tags");
                            break;
                        case "6D0000000000000000000000":
                            MessageBox.Show("Command format error");
                            break;
                        case "6E0000000000000000000000":
                            MessageBox.Show("Failed to set power strength");
                            break;
                        case "6F0000000000000000000000":
                            MessageBox.Show("Failed to set regulations");
                            break;
                        default:
                            MessageBox.Show(data);
                            break;
                    }
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
            if (IsRealStatus == true)
                startSendCmdTimer();
        }

        private void PrintQRcodeBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.clearbuffer();
                driver.qrcode("220", "260", "M", "3", "A", "0", "AABCB03abcN123");
                driver.printlabel("1", "1");
                driver.closeport();
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintQRcodeUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    usb.qrcode_USB("220", "260", "M", "3", "A", "0", "AABCB03abcN123");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.qrcode_Ethernet("220", "260", "M", "3", "A", "0", "AABCB03abcN123");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void DetectPrinter_Click(object sender, RoutedEventArgs e)
        {
            /* 偵測印表機裝置 */
            PrinterNameCom.Items.Clear();
            string[] PrinterName = usb.detectUSB_USB();
            //          string[] PrinterName= usb.detectUSBStr_USB() == null ? null : usb.detectUSBStr_USB().Split('\n'); 
            if (PrinterName != null)
            {
                for (int PrinterIndex = 0; PrinterIndex < PrinterName.Length; PrinterIndex++)
                {
                    if (PrinterName[PrinterIndex] != null)
                        PrinterNameCom.Items.Insert(PrinterIndex, PrinterName[PrinterIndex]);
                }
            }
            PrinterNameCom.SelectedIndex = PrinterNameCom.Items.Count - 1;
        }

        private void RFIDAutoCalibrationBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.RFIDAutoCalibration();
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void RFIDAutoCalibrationUSBBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.RFIDAutoCalibration_USB();
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.RFIDAutoCalibration_Ethernet();
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrinterRealTimeStatus_Click(object sender, RoutedEventArgs e)
        {

            if (PortTab.SelectedIndex == 1)
            {
                if (RealTimeStatusUSB.Content.ToString() == "Open Real Time Status")
                {
                    IsRealStatus = true;
                    RealTimeStatusUSB.Content = "Close Real Time Status";
                    startSendCmdTimer();
                }
                else
                {
                    IsRealStatus = false;
                    RealTimeStatusUSB.Content = "Open Real Time Status";
                    stopSendCmdTimer();
                }
            }
            else
            {
                if (RealTimeStatusEthernet.Content.ToString() == "Open Real Time Status")
                {
                    IsRealStatus = true;
                    RealTimeStatusEthernet.Content = "Close Real Time Status";
                    startSendCmdTimer();
                }
                else
                {
                    IsRealStatus = false;
                    RealTimeStatusEthernet.Content = "Open Real Time Status";
                    stopSendCmdTimer();
                }
            }
        }

        private void setDirectionAndMirrorBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.setDirectionAndMirror_USB(1, 1);
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.setDirectionAndMirror_Ethernet(1, 1);
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void setShiftBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.setShift_USB(50);
                    usb.clearbuffer_USB();
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.setShift_Ethernet(50);
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void printReverseBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    usb.sendcommand_USB("TEXT 100,100,\"3\",0,1,1,\"REVERSE\"");
                    usb.printReverse_USB(90, 90, 128, 40);
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.sendcommand_Ethernet("TEXT 100,100,\"3\",0,1,1,\"REVERSE\"");
                    socketconnect.printReverse_Ethernet(90, 90, 128, 40);
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void setAfterPrintActionBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.setAfterPrintAction_USB(2);
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.setAfterPrintAction_Ethernet(2);
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void setOffsetBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.setOffset_USB(20);
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.setOffset_Ethernet(20);
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void genericDefaultBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.genericDefault_USB();
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.genericDefault_Ethernet();
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void sensorDefaultBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.sensorDefault_USB();
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.sensorDefault_Ethernet();
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void rfidSetupDefaultBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.rfidSetupDefault_USB();
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.rfidSetupDefault_Ethernet();
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void SetRFIDPorcedure_mmBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.Set_RFIDPorcedure_mm_USB(5, 40, 32, 5, "N", 5, 5, "203");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.Set_RFIDPorcedure_mm_Ethernet(5, 40, 32, 5, "N", 5, 5, "203");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void setDirectionAndMirrorDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.setDirectionAndMirror(1, 1);
                driver.printlabel("1", "1");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void setShiftDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.setShift(50);
                driver.clearbuffer();
                driver.printlabel("1", "1");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void printReverseDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.clearbuffer();
                driver.sendcommand("TEXT 100,100,\"3\",0,1,1,\"REVERSE\"");
                driver.printReverse(90, 90, 128, 40);
                driver.printlabel("1", "1");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void setAfterPrintActionDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.setAfterPrintAction(2);
                driver.printlabel("1", "1");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void setOffsetDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.setOffset(20);
                driver.printlabel("1", "1");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void setCutModeDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.setCutMode(0, 2);
                driver.printlabel("1", "1");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void genericDefaultDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.genericDefault();
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void sensorDefaultDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.sensorDefault();
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void rfidSetupDefaultDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.rfidSetupDefault();
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void SetRFIDPorcedure_mmDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.Set_RFIDPorcedure_mm(5, 40, 32, 5, "N", 5, 5, "203");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void SetWifiFreqDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.WifiFrequency("5G");
                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintCompressBMPDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.clearbuffer();
                int BitmapResult = driver.compressBitmap("100", "70", 666, 357, "Cat1.jpg");
                if (BitmapResult!=0)
                    driver.printlabel("1", "1");

                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintCompressBMPBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    int BitmapResult=usb.compressBitmap_USB("100", "70", 666, 357, "Cat1.jpg");
                    if (BitmapResult != 0)
                        usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    int BitmapResult = socketconnect.compressBitmap_Ethernet("100", "70", 666, 357, "Cat1.jpg");
                    if (BitmapResult != 0)
                        socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintBMPDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.clearbuffer();
                int BitmapResult = driver.Bitmap("-500", "70", 400, 350, 1, "Thunder.png");
                if (BitmapResult != 0)
                    driver.printlabel("1", "1");

                driver.closeport(); //沒有close沒辦法使用
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintBmpBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    int BitmapResult = usb.Bitmap_USB("0", "70", 400, 350, 1, "CIRCLE.BMP");
                    if (BitmapResult != 0)
                        usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    int BitmapResult = socketconnect.Bitmap_Ethernet("0", "70", 400, 350, 1, "CIRCLE.BMP");
                    if (BitmapResult != 0)
                        socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PCWriteBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.writeUHF_USB("H", 1, 2, "E", "3000");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.writeUHF_Ethernet("H", 1 , 2, "E", "3000");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void RWPrintBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    string data = usb.readUHF_USB("H", 2, 12, "E");
                    switch (data)
                    {
                        case "640000000000000000000000":
                            MessageBox.Show("Other errors");
                            break;
                        case "650000000000000000000000":
                            MessageBox.Show("More than memory space");
                            break;
                        case "660000000000000000000000":
                            MessageBox.Show("The memory is locked");
                            break;
                        case "670000000000000000000000":
                            MessageBox.Show("Insufficient reading power");
                            break;
                        case "680000000000000000000000":
                            MessageBox.Show("Unspecified error");
                            break;
                        case "690000000000000000000000":
                            MessageBox.Show("CRC error");
                            break;
                        case "6A0000000000000000000000":
                            MessageBox.Show("If an error occurs during writing, how many words have been written in the reply.");
                            break;
                        case "6B0000000000000000000000":
                            MessageBox.Show("If the Tag tag responds incorrectly during writing, the error code plus the number of words written.");
                            break;
                        case "6C0000000000000000000000":
                            MessageBox.Show("No tags");
                            break;
                        case "6D0000000000000000000000":
                            MessageBox.Show("Command format error");
                            break;
                        case "6E0000000000000000000000":
                            MessageBox.Show("Failed to set power strength");
                            break;
                        case "6F0000000000000000000000":
                            MessageBox.Show("Failed to set regulations");
                            break;
                        default:
                            MessageBox.Show(data);
                            break;
                    }
                    usb.writeUHF_USB("H", 2, 12, "E", "112233445566778800010204");
                    usb.clearbuffer_USB();
                    usb.printerfont_USB("100", "160", "3", "0", "1", "1", "SHIFT 0 CHARACTERS");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    string data = socketconnect.readUHF_Ethernet("H", 2, 12, "E");
                    switch (data)
                    {
                        case "640000000000000000000000":
                            MessageBox.Show("Other errors");
                            break;
                        case "650000000000000000000000":
                            MessageBox.Show("More than memory space");
                            break;
                        case "660000000000000000000000":
                            MessageBox.Show("The memory is locked");
                            break;
                        case "670000000000000000000000":
                            MessageBox.Show("Insufficient reading power");
                            break;
                        case "680000000000000000000000":
                            MessageBox.Show("Unspecified error");
                            break;
                        case "690000000000000000000000":
                            MessageBox.Show("CRC error");
                            break;
                        case "6A0000000000000000000000":
                            MessageBox.Show("If an error occurs during writing, how many words have been written in the reply.");
                            break;
                        case "6B0000000000000000000000":
                            MessageBox.Show("If the Tag tag responds incorrectly during writing, the error code plus the number of words written.");
                            break;
                        case "6C0000000000000000000000":
                            MessageBox.Show("No tags");
                            break;
                        case "6D0000000000000000000000":
                            MessageBox.Show("Command format error");
                            break;
                        case "6E0000000000000000000000":
                            MessageBox.Show("Failed to set power strength");
                            break;
                        case "6F0000000000000000000000":
                            MessageBox.Show("Failed to set regulations");
                            break;
                        default:
                            MessageBox.Show(data);
                            break;
                    }
                    socketconnect.writeUHF_Ethernet("H", 2, 12, "E", "112233445566778800010204");
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.printerfont_Ethernet("100", "160", "3", "0", "1", "1", "SHIFT 0 CHARACTERS");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PrintRWBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = 0;
            if (PortTab.SelectedIndex == 1)
            {
                if (PrinterNameCom.SelectedItem != null)
                    result = OpenPortsUSB(PrinterNameCom.SelectedItem.ToString());
            }
            else
                result = OpenPortEthernet();
            if (result != 0)
            {
                if (PortTab.SelectedIndex == 1)
                {
                    usb.clearbuffer_USB();
                    usb.printerfont_USB("100", "160", "3", "0", "1", "1", "SHIFT 0 CHARACTERS");
                    string data = usb.readUHF_USB("H", 2, 12, "E");
                    switch (data)
                    {
                        case "640000000000000000000000":
                            MessageBox.Show("Other errors");
                            break;
                        case "650000000000000000000000":
                            MessageBox.Show("More than memory space");
                            break;
                        case "660000000000000000000000":
                            MessageBox.Show("The memory is locked");
                            break;
                        case "670000000000000000000000":
                            MessageBox.Show("Insufficient reading power");
                            break;
                        case "680000000000000000000000":
                            MessageBox.Show("Unspecified error");
                            break;
                        case "690000000000000000000000":
                            MessageBox.Show("CRC error");
                            break;
                        case "6A0000000000000000000000":
                            MessageBox.Show("If an error occurs during writing, how many words have been written in the reply.");
                            break;
                        case "6B0000000000000000000000":
                            MessageBox.Show("If the Tag tag responds incorrectly during writing, the error code plus the number of words written.");
                            break;
                        case "6C0000000000000000000000":
                            MessageBox.Show("No tags");
                            break;
                        case "6D0000000000000000000000":
                            MessageBox.Show("Command format error");
                            break;
                        case "6E0000000000000000000000":
                            MessageBox.Show("Failed to set power strength");
                            break;
                        case "6F0000000000000000000000":
                            MessageBox.Show("Failed to set regulations");
                            break;
                        default:
                            MessageBox.Show(data);
                            break;
                    }
                    usb.writeUHF_USB("H", 2, 12, "E", "112233445566778800010204");
                    usb.printlabel_USB("1", "1");
                    usb.closeport_USB();
                }
                else
                {
                    socketconnect.clearbuffer_Ethernet();
                    socketconnect.printerfont_Ethernet("100", "160", "3", "0", "1", "1", "SHIFT 0 CHARACTERS");
                    string data = socketconnect.readUHF_Ethernet("H", 2, 12, "E");
                    switch (data)
                    {
                        case "640000000000000000000000":
                            MessageBox.Show("Other errors");
                            break;
                        case "650000000000000000000000":
                            MessageBox.Show("More than memory space");
                            break;
                        case "660000000000000000000000":
                            MessageBox.Show("The memory is locked");
                            break;
                        case "670000000000000000000000":
                            MessageBox.Show("Insufficient reading power");
                            break;
                        case "680000000000000000000000":
                            MessageBox.Show("Unspecified error");
                            break;
                        case "690000000000000000000000":
                            MessageBox.Show("CRC error");
                            break;
                        case "6A0000000000000000000000":
                            MessageBox.Show("If an error occurs during writing, how many words have been written in the reply.");
                            break;
                        case "6B0000000000000000000000":
                            MessageBox.Show("If the Tag tag responds incorrectly during writing, the error code plus the number of words written.");
                            break;
                        case "6C0000000000000000000000":
                            MessageBox.Show("No tags");
                            break;
                        case "6D0000000000000000000000":
                            MessageBox.Show("Command format error");
                            break;
                        case "6E0000000000000000000000":
                            MessageBox.Show("Failed to set power strength");
                            break;
                        case "6F0000000000000000000000":
                            MessageBox.Show("Failed to set regulations");
                            break;
                        default:
                            MessageBox.Show(data);
                            break;
                    }
                    socketconnect.writeUHF_Ethernet("H", 2, 12, "E", "112233445566778800010204");
                    socketconnect.printlabel_Ethernet("1", "1");
                    socketconnect.closeport_Ethernet();
                }
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }

        private void PCWriteDrvBtn_Click(object sender, RoutedEventArgs e)
        {
            int result = OpenPort();
            if (result != 0)
            {
                driver.writeUHF("H", 1, 2, "E", "3000");
                driver.printlabel("1", "1");
                driver.closeport();
            }
            else
            {
                MessageBox.Show("Fail to open port!");
            }
        }
    }
}
